package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A Maximum Thread constraint in a {@link WlsDomain WLS domain}. To be used
 * in conjunction with a {@link WlsWorkManager Work Manager}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Work Manager that defines a set of request classes and thread constraints that manage work performed by WebLogic Server instances.")
public class WlsMaximumThreadsConstraint extends BaseConfigurationItem {
	
	@ConfigurationItemProperty(description = "Name of the Work Manager", required = true)
	private String name;
	
	@ConfigurationItemProperty(required = true)
	private int threadCount;
	
	@ConfigurationItemProperty
	private String notes;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getThreadCount() {
		return threadCount;
	}

	public void setThreadCount(int threadCount) {
		this.threadCount = threadCount;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}
	
}
