package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A JMS module defined in a {@link WlsDomain WLS domain}.
 * <p>
 * Resources in a JMS module should not be specific to a single application,
 * if possible, i.e. not shared between multiple applications. This increases
 * visibility and manageability of JMS resources related to a given application. 
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A Weblogic JMS Module")
public class WlsJmsModule extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "The name of the module. e.g. PetClinicModule-private", required = true)
	private String name;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
