package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * A JMS connection factory defined in a WLS {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A Weblogic JMS Conenction Factory")
public class WlsJmsConnectionFactory extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "The name of the connection factory.", required = true)
	private String name;

	@ConfigurationItemProperty(required = true)
	private String jndiName;

	@ConfigurationItemProperty(description = "The JMS module the connection factory should be included in.", required = true)
	private WlsJmsModule parentJmsModule;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public WlsJmsModule getParentJmsModule() {
		return parentJmsModule;
	}

	public void setParentJmsModule(WlsJmsModule parentModule) {
		this.parentJmsModule = parentModule;
	}
}
