package com.xebialabs.deployit.plugin.wls.ci;

import static com.xebialabs.deployit.util.ExtendedStringUtils.getQuotedString;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.Transformer;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemLabel;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;

/**
 * A cluster in a {@link WlsDomain WLS domain}.
 * 
 * @see WlsServer
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A WebLogic Cluster, a member of WebLogic Domain. It can have WebLogicServers as it's members", expandable = true, category = "middleware")
public class WlsCluster extends BaseConfigurationItem {
	
	public static final Transformer TOSTRING_FROM_NAME = new Transformer() {
		public String transform(Object obj) {
			return ((WlsCluster) obj).getName();
		}
	};

	@ConfigurationItemProperty(required = true, description = "Name of the WebLogic Cluster", identifying = true)
	private String name = "";

	@ConfigurationItemProperty(required = true, description = "The domain the WebLogic Cluster belongs to")
	private WlsDomain domain;

	@ConfigurationItemProperty(description = "Servers in the WebLogic Cluster")
	private Set<WlsServer> servers = new HashSet<WlsServer>();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public WlsDomain getDomain() {
		return domain;
	}

	public void setDomain(WlsDomain domain) {
		this.domain = domain;
	}

	public Set<WlsServer> getServers() {
		return Collections.unmodifiableSet(servers);
	}

	public void setServers(Set<WlsServer> servers) {
		this.servers = servers;
	}

	public Host getHost() {
		return getDomain().getActiveHost();
	}
}
