package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * Configuration for the <a href="http://download.oracle.com/docs/cd/E11035_01/wls100/plugins/apache.html">
 * Apache WebLogic plugin</a> in situations where the target environment contains
 * Apache web servers which &quot;front&quot; WLS servers.
 * <p>
 * Supports redirection by MIME match expressions and by target paths.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "An abstraction of Apache Weblogic Plugin Configuration. It is used to generate the configuration file which is included in the Apache main httpd.conf file", category = "middleware")
public class ApacheHttpdWlsPluginConfiguration extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "Comma separated list of match expression to proxy requests by MIME type")
	private String mimeMatchExpressions;

	@ConfigurationItemProperty(description = "Error Page")
	private String errorPage;

	@ConfigurationItemProperty(description = "Comma separated list of path to be used for proxing requests by path")
	private String pathExpressions;

	public String getMimeMatchExpressions() {
		return mimeMatchExpressions;
	}

	public void setMimeMatchExpressions(String mimeMatchExpressions) {
		this.mimeMatchExpressions = mimeMatchExpressions;
	}

	public String getErrorPage() {
		return errorPage;
	}

	public void setErrorPage(String errorPage) {
		this.errorPage = errorPage;
	}

	public String getPathExpressions() {
		return pathExpressions;
	}

	public void setPathExpressions(String pathExpressions) {
		this.pathExpressions = pathExpressions;
	}

}
