package com.xebialabs.deployit.plugin.wls;

import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * A factory for Deployit WLS conventions like library location paths etc.
 * <p>
 * <em>TODO:</em> Perhaps make this configurable, e.g. via Spring or the manifest. 
 */
public final class WlsConventions {
	private static final String CUSTOM_LIBRARY_PATTERN = " /opt/bea-10.3/user_projects/domains/%s/application/%s/libraries/";
	private static final String CUSTOM_CONFIGURATION_PATTERN = "/opt/bea-10.3/user_projects/domains/%s/application/%s/configuration/";
	private static final String FILESTORE_PATTERN = "/opt/bea-10.3/user_projects/domains/%s/filestores/";
	
	public static String getCustomLibraryPath(WlsDomain domain, Application app) {
		return String.format(CUSTOM_LIBRARY_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()),
				ExtendedStringUtils.getQuotedString(app.getLabel()));
	}
	
	public static String getCustomConfigurationPath(WlsDomain domain, Application app) {
		return String.format(CUSTOM_CONFIGURATION_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()),
				ExtendedStringUtils.getQuotedString(app.getLabel()));
	}	
	
	public static String getFilestorePath(WlsDomain domain) {
		return String.format(FILESTORE_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()));
	}	
	
}
