/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A standard Weblogic Server")
public class WlsServer
extends WlsTarget {
    @ConfigurationItemProperty(required=true, description="Name of the WebLogic Server")
    private String name;
    @ConfigurationItemProperty(required=true, description="Port for the WebLogic Server")
    private int port;
    @ConfigurationItemProperty(description="Classpath entries for this deployment.")
    private String classpath;
    @ConfigurationItemProperty(description="Boot classpath entries for this deployment.")
    private String bootClasspath;
    @ConfigurationItemProperty(description="Initial heap size to be allocated to the JVM (in megabytes).")
    private int initHeapSize;
    @ConfigurationItemProperty(description="Maximum heap size to be allocated to the JVM (in megabytes).")
    private int maxHeapSize;
    @ConfigurationItemProperty(description="The arguments to use when starting this server.", size=ConfigurationItemProperty.Size.LARGE)
    private String arguments;
    @ConfigurationItemProperty(description="Absolute path of log file. Example; /opt/bea/user_projects/domain/managedserver1/ms1.log")
    private String logFileLocation;
    @ConfigurationItemProperty(description="Enable JVM StdOut to Server Log file")
    private boolean enableJVMLogRedirection = false;
    @ConfigurationItemProperty(required=true, description="WebLogic Domain to which this server belongs")
    private WlsDomain domain;
    @ConfigurationItemProperty(required=true, description="Host on which this server is running")
    private Host host;

    public static List<WlsServer> toNameSortedList(Set<WlsServer> servers) {
        ArrayList<WlsServer> nameSortedServers = new ArrayList<WlsServer>(servers);
        Collections.sort(nameSortedServers, new BeanComparator("name"));
        return nameSortedServers;
    }

    @Override
    public String getTargetObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Server";
    }

    @Override
    public WlsDomain getDomain() {
        return this.domain;
    }

    public void setDomain(WlsDomain domain) {
        this.domain = domain;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(String bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    public int getInitHeapSize() {
        return this.initHeapSize;
    }

    public void setInitHeapSize(int initHeapSize) {
        this.initHeapSize = initHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public String getLogFileLocation() {
        return this.logFileLocation;
    }

    public void setLogFileLocation(String logFileLocation) {
        this.logFileLocation = logFileLocation;
    }

    public boolean isEnableJVMLogRedirection() {
        return this.enableJVMLogRedirection;
    }

    public void setEnableJVMLogRedirection(boolean enableJVMLogRedirection) {
        this.enableJVMLogRedirection = enableJVMLogRedirection;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }
}

