package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Creates a {@link WlsJmsServer JMS server}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsServerStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-server.py";

	public CreateWlsJmsServerStep(WlsServer server, WlsJmsServer jmsServer) {
		super("Create JMS Server " + jmsServer + " on domain " + server.getDomain() + " targeted at " + server, server.getDomain(), SCRIPT_RESOURCE_PATH, server
				.getTargetObjectName(), jmsServer.getName(), jmsServer.getFileStoreName(), jmsServer.getFileStorePath());
	}

}
