/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;

/**
 * Creates a {@link WlsDataSource JDBC data source}.
 */
@SuppressWarnings("serial")
public class CreateWlsDataSourceStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";

	public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
		super("Create datasource " + wlsDataSource + " on cluster " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(cluster.getName(),
				wlsDataSource));
	}

	private static String[] getArgs(String targetname, WlsDataSource webLogicDatasource) {
		List<String> args = new ArrayList<String>();
		args.add(targetname);
		args.add(webLogicDatasource.getName());
		args.add(webLogicDatasource.getJndiName());
		args.add(webLogicDatasource.getUri());
		args.add(webLogicDatasource.getUserName());
		args.add(webLogicDatasource.getPassword());
		args.add(webLogicDatasource.getDriver());
		args.add(String.valueOf(webLogicDatasource.getInit()));
		args.add(String.valueOf(webLogicDatasource.getMax()));
		args.add(webLogicDatasource.getProperties());
		return args.toArray(new String[args.size()]);
	}

}
