/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.GenericFolderToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.SqlFolderToDatabaseMapper;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.apache.httpd.step.CreateApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.DestroyApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasUnmanagedServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.EjbJarToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.SharedLibraryToWasScopeTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasUnmanagedServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasDataSourceToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasJndiPropertiesToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueConnectionFactoryToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicConnectionFactoryToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.runbook.WasClusterRunBook;
import com.xebialabs.deployit.plugin.was.runbook.WasServerRunBook;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment>
implements RunBook {
    public WasDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        Set<Object> affectedWasTargets = new HashSet();
        EarToWasClusterMapper earToClusterMapper = new EarToWasClusterMapper(change);
        EarToWasServerMapper earToServerMapper = new EarToWasServerMapper(change);
        EarToWasUnmanagedServerMapper earToWasUnmanagedServerMapper = new EarToWasUnmanagedServerMapper(change);
        WarToWasClusterMapper warToClusterMapper = new WarToWasClusterMapper(change);
        WarToWasServerMapper warToServerMapper = new WarToWasServerMapper(change);
        WarToWasUnmanagedServerMapper warToUnmanagedServerMapper = new WarToWasUnmanagedServerMapper(change);
        EjbJarToWasTargetMapper ejbJarMapper = new EjbJarToWasTargetMapper(change);
        StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);
        WasDataSourceToWasTargetMapper dsToClusterMapper = new WasDataSourceToWasTargetMapper(change);
        WasWmqQueueToWasTargetMapper qToClusterMapper = new WasWmqQueueToWasTargetMapper(change);
        WasWmqQueueConnectionFactoryToWasTargetMapper qcfToClusterMapper = new WasWmqQueueConnectionFactoryToWasTargetMapper(change);
        WasWmqTopicToWasTargetMapper tToServerMapper = new WasWmqTopicToWasTargetMapper(change);
        WasWmqTopicConnectionFactoryToWasTargetMapper tcfToClusterMapper = new WasWmqTopicConnectionFactoryToWasTargetMapper(change);
        WasJndiPropertiesToWasTargetMapper jndiPropertiesToClusterMapper = new WasJndiPropertiesToWasTargetMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        LibrariesToHostMapper librariesToHostMapper = new LibrariesToHostMapper(change);
        SharedLibraryToWasScopeTargetMapper sharedLibToWasScopeTargetMapper = new SharedLibraryToWasScopeTargetMapper(change);
        SqlFolderToDatabaseMapper sqlFoldermapper = new SqlFolderToDatabaseMapper(change);
        SqlScriptToDatabaseMapper sqlScriptMapper = new SqlScriptToDatabaseMapper(change);
        GenericFolderToHostMapper genericFolderToHostMapper = new GenericFolderToHostMapper(change);
        affectedWasTargets = this.getAffectedWasTargets(new Mapper[]{earToClusterMapper, earToServerMapper, earToWasUnmanagedServerMapper, warToClusterMapper, warToServerMapper, warToUnmanagedServerMapper, ejbJarMapper, dsToClusterMapper, qToClusterMapper, qcfToClusterMapper, tToServerMapper, tcfToClusterMapper, jndiPropertiesToClusterMapper, sharedLibToWasScopeTargetMapper});
        if (affectedWasTargets.isEmpty()) {
            return;
        }
        HashSet<WasNodeAgent> affectedWasNodes = new HashSet<WasNodeAgent>();
        for (WasScope wasScope : affectedWasTargets) {
            if (wasScope instanceof WasTarget) {
                affectedWasNodes.addAll(((WasTarget)wasScope).getNodes());
                continue;
            }
            if (!(wasScope instanceof WasNodeAgent)) continue;
            affectedWasNodes.add((WasNodeAgent)wasScope);
        }
        int lastStepCount = steps.size();
        HashMap<ApacheHttpdServer, Set<String>> hashMap = new HashMap<ApacheHttpdServer, Set<String>>();
        earToClusterMapper.setVirtualHostsPerWebServerCollector(hashMap);
        earToClusterMapper.generateDeletionSteps(steps);
        earToServerMapper.setVirtualHostsPerWebServerCollector(hashMap);
        earToServerMapper.generateDeletionSteps(steps);
        earToWasUnmanagedServerMapper.setVirtualHostsPerWebServerCollector(hashMap);
        earToWasUnmanagedServerMapper.generateDeletionSteps(steps);
        warToClusterMapper.setVirtualHostsPerWebServerCollector(hashMap);
        warToClusterMapper.generateDeletionSteps(steps);
        warToServerMapper.setVirtualHostsPerWebServerCollector(hashMap);
        warToServerMapper.generateDeletionSteps(steps);
        warToUnmanagedServerMapper.setVirtualHostsPerWebServerCollector(hashMap);
        warToUnmanagedServerMapper.generateDeletionSteps(steps);
        ejbJarMapper.generateDeletionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.synchronizeNodes(affectedWasNodes, steps);
        }
        lastStepCount = steps.size();
        tToServerMapper.generateDeletionSteps(steps);
        tcfToClusterMapper.generateDeletionSteps(steps);
        qToClusterMapper.generateDeletionSteps(steps);
        qcfToClusterMapper.generateDeletionSteps(steps);
        dsToClusterMapper.generateDeletionSteps(steps);
        jndiPropertiesToClusterMapper.generateDeletionSteps(steps);
        sharedLibToWasScopeTargetMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        librariesToHostMapper.generateDeletionSteps(steps);
        genericFolderToHostMapper.generateDeletionSteps(steps);
        genericFolderToHostMapper.generateAdditionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        librariesToHostMapper.generateAdditionSteps(steps);
        sharedLibToWasScopeTargetMapper.generateAdditionSteps(steps);
        sharedLibToWasScopeTargetMapper.generateModificationSteps(steps);
        if (steps.size() > lastStepCount) {
            this.synchronizeNodes(affectedWasNodes, steps);
        }
        WasClusterRunBook wasClusterRunBook = new WasClusterRunBook();
        Set<Change<WasCluster>> clusterChanges = this.findClusterChangesForDeploymentChange(change, changePlan);
        for (Change<WasCluster> eachClusterChange : clusterChanges) {
            if (eachClusterChange.isModification()) {
                wasClusterRunBook.getStepsForModifiedCluster(steps, (WasCluster)eachClusterChange.getOldRevision(), (WasCluster)eachClusterChange.getNewRevision(), changePlan);
                continue;
            }
            if (eachClusterChange.isAddition()) {
                throw new ResolutionException("Cannot deploy an application to a Cluster which needs to be created. Please create the cluster first before deploying to it.");
            }
            if (!eachClusterChange.isDeletion()) continue;
            throw new ResolutionException("Cannot deploy an application to a Cluster which will be deleted. Please point the deployment to another cluster.");
        }
        WasServerRunBook wasServerRunBook = new WasServerRunBook();
        Set<Change<WasManagedServer>> serverChanges = this.findServerChangesForDeploymentChange(change, changePlan);
        for (Change<WasManagedServer> eachServerChange : serverChanges) {
            wasServerRunBook.getStepsForModifiedServer(steps, (WasManagedServer)eachServerChange.getOldRevision(), (WasManagedServer)eachServerChange.getNewRevision());
        }
        lastStepCount = steps.size();
        sqlFoldermapper.generateAdditionSteps(steps);
        sqlScriptMapper.generateAdditionSteps(steps);
        HashMap<ApacheHttpdServer, Set<String>> virtualHostsPerWebServerToCreate = new HashMap<ApacheHttpdServer, Set<String>>();
        jndiPropertiesToClusterMapper.generateAdditionSteps(steps);
        dsToClusterMapper.generateAdditionSteps(steps);
        qcfToClusterMapper.generateAdditionSteps(steps);
        qToClusterMapper.generateAdditionSteps(steps);
        tcfToClusterMapper.generateAdditionSteps(steps);
        tToServerMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.synchronizeNodes(affectedWasNodes, steps);
        }
        lastStepCount = steps.size();
        ejbJarMapper.generateAdditionSteps(steps);
        warToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warToClusterMapper.generateAdditionSteps(steps);
        warToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warToServerMapper.generateAdditionSteps(steps);
        warToUnmanagedServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warToUnmanagedServerMapper.generateAdditionSteps(steps);
        earToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earToClusterMapper.generateAdditionSteps(steps);
        earToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earToServerMapper.generateAdditionSteps(steps);
        earToWasUnmanagedServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earToWasUnmanagedServerMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.synchronizeNodes(affectedWasNodes, steps);
        }
        earToClusterMapper.generateModificationSteps(steps);
        warToClusterMapper.generateModificationSteps(steps);
        earToServerMapper.generateModificationSteps(steps);
        warToServerMapper.generateModificationSteps(steps);
        warToUnmanagedServerMapper.generateModificationSteps(steps);
        earToWasUnmanagedServerMapper.generateModificationSteps(steps);
        ejbJarMapper.generateStartSteps(steps);
        warToClusterMapper.generateStartSteps(steps);
        warToServerMapper.generateStartSteps(steps);
        warToUnmanagedServerMapper.generateStartSteps(steps);
        earToClusterMapper.generateStartSteps(steps);
        earToServerMapper.generateStartSteps(steps);
        earToWasUnmanagedServerMapper.generateStartSteps(steps);
        earToClusterMapper.generateAndCopyPluginSteps(steps);
        warToClusterMapper.generateAndCopyPluginSteps(steps);
        earToServerMapper.generateAndCopyPluginSteps(steps);
        warToServerMapper.generateAndCopyPluginSteps(steps);
        warToUnmanagedServerMapper.generateAndCopyPluginSteps(steps);
        earToWasUnmanagedServerMapper.generateAndCopyPluginSteps(steps);
        staticContentMapper.generateDeletionSteps(steps);
        this.destroyApacheVirtualHosts(hashMap, steps);
        this.restartApacheWebServers(hashMap, steps);
        this.createApacheVirtualHosts(virtualHostsPerWebServerToCreate, steps);
        staticContentMapper.generateAdditionSteps(steps);
        this.restartApacheWebServers(virtualHostsPerWebServerToCreate, steps);
    }

    private void synchronizeNodes(Set<WasNodeAgent> affectedWasNodes, List<Step> steps) {
        for (WasNodeAgent node : affectedWasNodes) {
            steps.add(new SynchronizeWasNodeStep(node));
        }
    }

    private Set<WasScope> getAffectedWasTargets(Mapper ... mappers) {
        HashSet<WasScope> affectedWasTargets = new HashSet<WasScope>();
        for (Mapper m : mappers) {
            affectedWasTargets.addAll(m.getAffectedTargets());
        }
        return affectedWasTargets;
    }

    private Set<Change<WasCluster>> findClusterChangesForDeploymentChange(Change<Deployment> deploymentChange, ChangePlan changePlan) {
        HashSet<Change<WasCluster>> clusterChanges = new HashSet<Change<WasCluster>>();
        for (Change change : changePlan.getChanges()) {
            Change clusterChange;
            if (change.getConfigurationItemClass() != WasCluster.class || !this.isClusterDeploymentTarget((WasCluster)(clusterChange = change).getOldRevision(), (Deployment)deploymentChange.getOldRevision()) && !this.isClusterDeploymentTarget((WasCluster)clusterChange.getNewRevision(), (Deployment)deploymentChange.getNewRevision()) && !this.isClusterDeploymentTarget((WasCluster)clusterChange.getNewRevision(), (Deployment)deploymentChange.getOldRevision()) && !this.isClusterDeploymentTarget((WasCluster)clusterChange.getOldRevision(), (Deployment)deploymentChange.getNewRevision())) continue;
            clusterChanges.add((Change<WasCluster>)clusterChange);
        }
        return clusterChanges;
    }

    private Set<Change<WasManagedServer>> findServerChangesForDeploymentChange(Change<Deployment> deploymentChange, ChangePlan changePlan) {
        HashSet<Change<WasManagedServer>> serverChanges = new HashSet<Change<WasManagedServer>>();
        for (Change change : changePlan.getChanges()) {
            Change serverChange;
            if (!change.isModification() || change.getConfigurationItemClass() != WasManagedServer.class || !this.isServerDeploymentTarget((WasManagedServer)(serverChange = change).getOldRevision(), (Deployment)deploymentChange.getOldRevision()) || !this.isServerDeploymentTarget((WasManagedServer)serverChange.getNewRevision(), (Deployment)deploymentChange.getNewRevision())) continue;
            serverChanges.add((Change<WasManagedServer>)serverChange);
        }
        return serverChanges;
    }

    private boolean isClusterDeploymentTarget(WasCluster cluster, Deployment deployment) {
        if (cluster != null && deployment != null) {
            List deployableArtifactMappings = deployment.getMappingsOfType(DeployableArtifactMapping.class);
            for (DeployableArtifactMapping eachMapping : deployableArtifactMappings) {
                if (!eachMapping.getTarget().equals(cluster)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isServerDeploymentTarget(WasManagedServer server, Deployment deployment) {
        List deployableArtifactMappings = deployment.getMappingsOfType(DeployableArtifactMapping.class);
        for (DeployableArtifactMapping eachMapping : deployableArtifactMappings) {
            if (!eachMapping.getTarget().equals(server)) continue;
            return true;
        }
        return false;
    }

    private void createApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new CreateApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost, Collections.singletonList(eachWebServer)));
            }
        }
    }

    private void destroyApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new DestroyApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost));
            }
        }
    }

    private void restartApacheWebServers(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (ApacheHttpdServer eachWebServer : virtualHostsPerWebServer.keySet()) {
            steps.add((Step)new RestartApacheHttpdServerStep(eachWebServer));
        }
    }
}

