/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderMode;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderPolicy;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarClassLoaderMapping;
import com.xebialabs.deployit.plugin.was.utils.WasEarUtils;
import com.xebialabs.deployit.plugin.was.utils.WebSphereNameBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A mapping of an EAR to a WebSphere target")
public class WasEarMapping
extends EarMapping<WasTarget> {
    @ConfigurationItemProperty(description="Set of webservers that expose the Eneterprise Application")
    private Set<WasManagedApacheHttpdServer> webservers;
    @ConfigurationItemProperty(description="Set of shared library which will used by the ear", category="Shared library references")
    private Set<WasSharedLibrary> sharedLibraries;
    @ConfigurationItemProperty(description="Specifies the order in which applications are started. Lower values start earlier.")
    private int startingWeight = 1;
    @ConfigurationItemProperty(description="If true, the artifact name will be suffixed with the name of the target.")
    private boolean suffixArtifactNameWithTarget = false;
    @ConfigurationItemProperty(description="Specifies the Classloader mode", category="Class loading")
    private WasClassLoaderMode classLoaderMode;
    @ConfigurationItemProperty(description="Specifies the Classloader policy", category="Class loading")
    private WasClassLoaderPolicy classLoaderPolicy;
    @ConfigurationItemProperty(description="Map Security role to users and groups used by EnterPrise Application", category="Security")
    private List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings;
    @ConfigurationItemProperty(description="Specifies the Class loader mode to WARs in EAR", category="Web modules")
    private List<WasWarClassLoaderMapping> warClassLoaderMapping;
    @ConfigurationItemProperty(description="Map Wars to Webservers and Virtual hosts in EnterPrise Application", category="Web modules")
    private List<WarsWebserversVirtualHostMapping> warsWebserversVirtualHostMapping;

    public WasEarMapping() {
        this.webservers = Collections.EMPTY_SET;
        this.sharedLibraries = Collections.EMPTY_SET;
        this.securityRoleUserGroupMappings = Collections.EMPTY_LIST;
        this.warClassLoaderMapping = Collections.EMPTY_LIST;
        this.warsWebserversVirtualHostMapping = Collections.EMPTY_LIST;
    }

    public WasEarMapping(Ear source, WasTarget target, String virtualHost) {
        this(source, target, Collections.EMPTY_SET, virtualHost);
    }

    public WasEarMapping(Ear source, WasTarget target, Set<WasManagedApacheHttpdServer> webservers, String virtualHost) {
        this(source, target, webservers, virtualHost, Collections.EMPTY_LIST);
    }

    public WasEarMapping(Ear source, WasTarget target, Set<WasManagedApacheHttpdServer> webservers, String virtualHost, List<WarsWebserversVirtualHostMapping> warsWebserversVirtualHostMapping) {
        super(source, (Serializable)target, virtualHost);
        this.webservers = webservers;
        this.sharedLibraries = Collections.EMPTY_SET;
        this.securityRoleUserGroupMappings = Collections.EMPTY_LIST;
        this.warsWebserversVirtualHostMapping = warsWebserversVirtualHostMapping;
    }

    public void postInit(Deployment deployment) {
        this.setVirtualHost(deployment.getVhostDefinition());
        this.securityRoleUserGroupMappings = WasEarUtils.getSecurityRoleUserGroupMappings(this.getSource());
        this.warsWebserversVirtualHostMapping = WasEarUtils.getWarsWebserversMapping(this.getSource());
        this.warClassLoaderMapping = WasEarUtils.getWasWarClassLoaderMappings(this.getSource());
    }

    public Ear getSource() {
        Ear ear = (Ear)super.getSource();
        if (!this.suffixArtifactNameWithTarget) {
            return ear;
        }
        Ear earWithSuffixedName = new Ear();
        earWithSuffixedName.setLabel(ear.getLabel());
        earWithSuffixedName.setLocation(ear.getLocation());
        earWithSuffixedName.setName(WebSphereNameBuilder.getDeployedApplicationName(ear, this));
        return earWithSuffixedName;
    }

    public int getStartingWeight() {
        return this.startingWeight;
    }

    public void setStartingWeight(int startingWeight) {
        this.startingWeight = startingWeight;
    }

    public boolean isSuffixArtifactNameWithTarget() {
        return this.suffixArtifactNameWithTarget;
    }

    public Set<WasManagedApacheHttpdServer> getWebservers() {
        return this.webservers;
    }

    public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
        this.webservers = webservers;
    }

    public Set<WasSharedLibrary> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public void setSharedLibraries(Set<WasSharedLibrary> sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public List<WarsWebserversVirtualHostMapping> getWarsWebserversVHMapping() {
        return this.warsWebserversVirtualHostMapping;
    }

    public void setWarsWebserversVHMapping(List<WarsWebserversVirtualHostMapping> warsWebserversVirtualHostMapping) {
        this.warsWebserversVirtualHostMapping = warsWebserversVirtualHostMapping;
    }

    public WasClassLoaderMode getClassLoaderMode() {
        return this.classLoaderMode;
    }

    public void setClassLoaderMode(WasClassLoaderMode classLoaderMode) {
        this.classLoaderMode = classLoaderMode;
    }

    public WasClassLoaderPolicy getClassLoaderPolicy() {
        return this.classLoaderPolicy;
    }

    public void setClassLoaderPolicy(WasClassLoaderPolicy classLoaderPolicy) {
        this.classLoaderPolicy = classLoaderPolicy;
    }

    public List<WasWarClassLoaderMapping> getWarClassLoaderMapping() {
        return this.warClassLoaderMapping;
    }

    public void setWarClassLoaderMapping(List<WasWarClassLoaderMapping> warClassLoaderMapping) {
        this.warClassLoaderMapping = warClassLoaderMapping;
    }

    public List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings() {
        return this.securityRoleUserGroupMappings;
    }

    public void setSecurityRoleUserGroupMappings(List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings) {
        this.securityRoleUserGroupMappings = securityRoleUserGroupMappings;
    }

    public void setSuffixArtifactNameWithTarget(boolean suffixArtifactNameWithTarget) {
        this.suffixArtifactNameWithTarget = suffixArtifactNameWithTarget;
    }
}

