/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasJndiProperties;
import com.xebialabs.deployit.plugin.was.ci.WasJndiPropertiesToWasScopeMapping;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.step.CreateWasStringNameSpaceBindingsStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasStringNameSpaceBindingsStep;

public class WasJndiPropertiesToWasTargetMapper extends StepGeneratingMapper<WasJndiProperties, WasJndiPropertiesToWasScopeMapping, WasScope> {

	private static final Function<Map.Entry<String, String>, KeyValuePair> fromEntryToKVPair = new Function<Map.Entry<String, String>, KeyValuePair>() {
		public KeyValuePair apply(Map.Entry<String, String> from) {
			return new KeyValuePair(from.getKey(), from.getValue());
		}
	};

	private static final Function<Map.Entry<String, MapDifference.ValueDifference<String>>, KeyValuePair> fromValueDifferenceToKVPair = new Function<Map.Entry<String, MapDifference.ValueDifference<String>>, KeyValuePair>() {
		public KeyValuePair apply(Map.Entry<String, MapDifference.ValueDifference<String>> from) {
			return new KeyValuePair(from.getKey(), from.getValue().rightValue());
		}
	};


	public WasJndiPropertiesToWasTargetMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping newMapping, WasScope target, List<Step> steps) {
		List<KeyValuePair> resolved = resolveKeyValuePairs(resource, newMapping);
		KeyValuePair[] pairs = resolved.toArray(new KeyValuePair[resolved.size()]);
		steps.add(new CreateWasStringNameSpaceBindingsStep(target, resource.getLabel(), pairs));
	}


	@Override
	protected void generateDeletionStepsForDeletedMapping(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping oldMapping, WasScope target, List<Step> steps) {
		List<KeyValuePair> resolved = resolveKeyValuePairs(resource, oldMapping);
		KeyValuePair[] pairs = resolved.toArray(new KeyValuePair[resolved.size()]);
		steps.add(new DestroyWasStringNameSpaceBindingsStep(target,resource.getLabel(), pairs));

	}

	static List<KeyValuePair> resolveKeyValuePairs(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping mapping) {
		final List<KeyValuePair> resolved = Lists.newArrayList();
		final MapDifference<String, String> difference = Maps.difference(KeyValuePair.toMap(resource.getStringNameSpaceBindings()), KeyValuePair.toMap(mapping.getKeyValuePairs()));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesOnlyOnRight().entrySet()), fromEntryToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesOnlyOnLeft().entrySet()), fromEntryToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesDiffering().entrySet()), fromValueDifferenceToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesInCommon().entrySet()), fromEntryToKVPair));
		return resolved;
	}


}
