#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys

sys.argv.reverse();
cellname = sys.argv.pop()
nodename = sys.argv.pop()
servername = sys.argv.pop()

print "Configuring server " + servername + " on node " + nodename + " in cell " + cellname

server = AdminConfig.getid('/Server:'+ servername +'/')
jvmConfig = AdminConfig.list("JavaVirtualMachine", server)
javaProcessDefConfig = AdminConfig.list('JavaProcessDef', server)
processExecutionConfig = AdminConfig.list('ProcessExecution', javaProcessDefConfig)
outputRedirectConfig = AdminConfig.list('OutputRedirect', javaProcessDefConfig)
applicationServerConfig = AdminConfig.list('ApplicationServer', server)
webContainerConfig = AdminConfig.list('WebContainer', server)
sessionManagerConfig = AdminConfig.list( 'SessionManager', server)
tuningParamsConfig = AdminConfig.list('TuningParams', sessionManagerConfig)
messageListenerService = AdminConfig.list('MessageListenerService', server)

# Cleanup the environment entries, as they're all sent in again
AdminConfig.modify(javaProcessDefConfig, [['environment', []]])
environmentEntries = []

while len(sys.argv) >= 2:
    propname = sys.argv.pop();
    propvalue = sys.argv.pop();
    
    print "Setting server property " + propname + " to value \"" + propvalue + "\""

    if propname == "classpath":
        AdminConfig.modify(jvmConfig,  [['classpath',  '']])
        AdminConfig.modify(jvmConfig,  [['classpath',  propvalue]])

    elif propname == "bootclasspath":
        AdminConfig.modify(jvmConfig,  [['bootClasspath',  '']])
        AdminConfig.modify(jvmConfig,  [['bootClasspath',  propvalue]])

    elif propname == "initheapsize":
        AdminConfig.modify(jvmConfig, [['initialHeapSize', propvalue]])

    elif propname == "maxheapsize":
        AdminConfig.modify(jvmConfig, [['maximumHeapSize', propvalue]])

    elif propname == "jvmargs":
        AdminConfig.modify(jvmConfig, [['genericJvmArguments', propvalue]])

    elif propname == "disablejit":
        AdminConfig.modify(jvmConfig, [['disableJIT', propvalue]])

    elif propname == "applicationclassloaderpolicy":
        AdminConfig.modify(applicationServerConfig, [['applicationClassLoaderPolicy', propvalue]])

    elif propname == "applicationclassloadingmode":
        AdminConfig.modify(applicationServerConfig, [['applicationClassLoadingMode', propvalue]])

    elif propname == "systempropertyclear":
        AdminConfig.modify(jvmConfig, [['systemProperties', []]])

    elif propname == "workdir":
        AdminConfig.modify(javaProcessDefConfig, [['workingDirectory', propvalue]])

    elif propname == "umask":
        AdminConfig.modify(processExecutionConfig, [['umask', propvalue]])

    elif propname == "servletcaching":
        AdminConfig.modify(webContainerConfig, [['enableServletCaching', propvalue]])

    elif propname == "sessmaxinmem":
        AdminConfig.modify(tuningParamsConfig, [['maxInMemorySessionCount', propvalue]])

    elif propname == "sesstimeout":
        AdminConfig.modify(tuningParamsConfig, [['invalidationTimeout', propvalue]])

    elif propname == "sesscookieenabled":
        AdminConfig.modify(sessionManagerConfig,  [['enableCookies', propvalue]])

    elif propname == "sesscookie":
        propvalue2 = sys.argv.pop()
        propvalue3 = sys.argv.pop()
        AdminConfig.modify(sessionManagerConfig,  [['defaultCookieSettings',  [['name', propvalue],['domain', propvalue2],['path', propvalue3]] ]])

    elif propname == "listenerportclear":
        AdminConfig.modify(messageListenerService, [['listenerPorts', []]])

    elif propname == "stdoutlog":
        AdminConfig.modify(outputRedirectConfig, [['stdoutFilename', propvalue]])

    elif propname == "stderrlog":
        AdminConfig.modify(outputRedirectConfig, [['stderrFilename', propvalue]])

    elif propname == "jvmstdoutlog":
        outputStreamRedirectConfig = AdminConfig.showAttribute(server, 'outputStreamRedirect')
        AdminConfig.modify(outputStreamRedirectConfig, [['fileName', propvalue]]);
        AdminConfig.modify(outputStreamRedirectConfig, [['rolloverType', 'NONE']])

    elif propname == "jvmstderrlog":
        errorStreamRedirectConfig = AdminConfig.showAttribute(server, 'errorStreamRedirect')
        AdminConfig.modify(errorStreamRedirectConfig, [['fileName', propvalue]]);
        AdminConfig.modify(errorStreamRedirectConfig, [['rolloverType', 'NONE']])

    elif propname.startswith("environment_"):
        realPropName = propname.split("_", 1)[1]
        entry = [['name', realPropName],['value', propvalue]]
        environmentEntries.append(entry)

    else:
        print "Skipping unknown property \"" + propname + "\" with value \"" + propvalue + "\""

# Send all the environment entries in one go.
AdminConfig.modify(javaProcessDefConfig, [['environment', environmentEntries]])

print "Saving configuration"
AdminConfig.save();
