/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.util.Map;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderPolicyAndMode;
import com.xebialabs.deployit.plugin.was.ci.WasServer;

/**
 * Retrieves ApplicationServer properties of of a server.
 */
@SuppressWarnings("serial")
public class RetrieveWasServerApplicationServerPropertiesStep extends WasStepBase {

	private WasServer server;

	public RetrieveWasServerApplicationServerPropertiesStep(WasServer server) {
		super(server.getCell());
		this.server = server;
		setDescription("Retrieve ApplicationServer properties of server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		ctx.logOutput("Retrieving server application class loader policies and mode");
		Map<String, String> webContainerProperties = cell.getObjectInfoWithSubLevelByType(ctx, "/Server:" + server.getName(), "ApplicationServer");
		if (webContainerProperties == null) {
			ctx.logError("Server " + server + "with technical name " + server.getName() + " does not exist in cell " + cell);
			return false;
		}

		String applicationClassLoaderPolicy = webContainerProperties.get("applicationClassLoaderPolicy");
		String applicationClassLoadingMode = webContainerProperties.get("applicationClassLoadingMode");
		if ("MULTIPLE".equalsIgnoreCase(applicationClassLoaderPolicy)) {
			server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.MULTIPLE);
		} else if ("SINGLE".equals(applicationClassLoaderPolicy)) {
			if ("PARENT_FIRST".equalsIgnoreCase(applicationClassLoadingMode)) {
				server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.SINGLE_PARENT_FIRST);
			} else if ("PARENT_LAST".equalsIgnoreCase(applicationClassLoadingMode)) {
				server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.SINGLE_PARENT_LAST);
			} else {
				logger.warn("Unknown application class loader mode: " + applicationClassLoadingMode);
			}
		} else {
			logger.warn("Unknown application class loader policy: " + applicationClassLoaderPolicy);
		}

		return true;
	}

	private static Logger logger = Logger.getLogger(RetrieveWasServerApplicationServerPropertiesStep.class);

}
