/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class CopyWasWebServerPluginConfigurationStep
extends WasStepBase {
    protected WasUnManagedApacheHttpdServer webserver;

    public CopyWasWebServerPluginConfigurationStep(WasUnManagedApacheHttpdServer webserver) {
        super(webserver.getNode().getCell());
        this.webserver = webserver;
        String fileSeparator = webserver.getHost().getFileSeparator();
        String webserverPluginFile = webserver.getPluginInstallationDirPath() + fileSeparator + webserver.getName() + fileSeparator + "plugin-cfg.xml";
        this.description = "Copy  plugin from location \"" + this.getPluginConfigurationFilePath() + "\" on Host \"" + webserver.getNode().getCell().getCellHost().getLabel() + "\" to \"" + webserverPluginFile + "\" on Host \"" + webserver.getHost().getLabel() + "\"";
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.copyPluginToWebserver(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyPluginToWebserver(StepExecutionContext ctx) {
        HostSession sourceSession = this.webserver.getNode().getCell().connectToAdminHost();
        HostSession destinationSession = this.webserver.getHost().getHostSession();
        try {
            HostFile sourceFile = sourceSession.getFile(this.getPluginConfigurationFilePath());
            String fileSeparator = this.webserver.getHost().getFileSeparator();
            String pluginConfDirectory = this.webserver.getPluginInstallationDirPath() + fileSeparator + this.webserver.getName();
            HostFile destinationPluginConfDirectory = destinationSession.getFile(pluginConfDirectory);
            destinationPluginConfDirectory.mkdirs();
            String webserverPluginFile = pluginConfDirectory + fileSeparator + "plugin-cfg.xml";
            HostFile destinationFile = destinationSession.getFile(webserverPluginFile);
            HostFileUtils.copy((HostFile)sourceFile, (HostFile)destinationFile);
            ctx.logOutput("Copied  plugin  successfully from location \"" + this.getPluginConfigurationFilePath() + "\" on Host \"" + this.webserver.getNode().getCell().getCellHost().getLabel() + "\" to \"" + webserverPluginFile + "\" on Host \"" + this.webserver.getHost().getLabel() + "\"");
            boolean bl = true;
            return bl;
        }
        finally {
            sourceSession.close();
            destinationSession.close();
        }
    }

    public String getPluginConfigurationFilePath() {
        return this.webserver.getNode().getCell().getWasHome() + "/config/cells/" + this.webserver.getNode().getCell().getCellName() + "/nodes/" + this.webserver.getNode().getNodeName() + "/servers/" + this.webserver.getName().trim() + "/plugin-cfg.xml";
    }
}

