/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.plugin.was.utils.RegexUtils;

public class RetrieveWasVersionStep
extends WasStepBase {
    public RetrieveWasVersionStep(WasCell cell) {
        super(cell);
        this.setDescription("Retrieve version of cell " + cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession adminHostSession = this.cell.connectToAdminHost();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            int res = adminHostSession.execute((CommandExecutionCallbackHandler)capturedOutput, new String[]{this.cell.getVersionInfoPath()});
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + this.cell.getVersionInfoPath() + ": " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                boolean correctVersion;
                int expectedMinorVersion;
                int expectedMajorVersion;
                String[] matches;
                if (!eachLine.startsWith("Version") || (matches = RegexUtils.regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*")) == null || matches.length != 2) continue;
                int majorVersion = Integer.parseInt(matches[0]);
                int minorVersion = Integer.parseInt(matches[1]);
                if (this.cell.getVersion() == WasVersion.WAS_61) {
                    expectedMajorVersion = 6;
                    expectedMinorVersion = 1;
                } else if (this.cell.getVersion() == WasVersion.WAS_70) {
                    expectedMajorVersion = 7;
                    expectedMinorVersion = 0;
                } else {
                    ctx.logOutput("There is no version set on cell " + this.cell + " trying to set it");
                    if (majorVersion == 6 && minorVersion == 1) {
                        this.cell.setVersion(WasVersion.WAS_61);
                        boolean bl = true;
                        return bl;
                    }
                    if (majorVersion == 7 && minorVersion == 0) {
                        this.cell.setVersion(WasVersion.WAS_70);
                        boolean bl = true;
                        return bl;
                    }
                    ctx.logError("Could not set version on cell " + this.cell + " majorVersion: " + majorVersion + " minorVersion: " + minorVersion + " Giving up");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = correctVersion = majorVersion == expectedMajorVersion && minorVersion == expectedMinorVersion;
                if (!correctVersion) {
                    ctx.logError("Cell " + this.cell + " is an installation of WebSphere " + majorVersion + "." + minorVersion + " instead of the expected " + expectedMajorVersion + "." + expectedMinorVersion);
                    boolean bl2 = false;
                    return bl2;
                }
                ctx.logOutput("Cell " + this.cell + " is an installation of WebSphere " + majorVersion + "." + minorVersion);
                boolean bl3 = true;
                return bl3;
            }
            ctx.logError("Could not determine installed version of cell " + this.cell);
            boolean bl = false;
            return bl;
        }
        finally {
            adminHostSession.close();
        }
    }
}

