/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.StartWasUnmanagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasUnmanagedServerStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasFileServingEnabledStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarToWasUnmanagedServerMapper
extends JeeWebArtifactToWasTargetMapper<Ear, WasEarMapping, WasUnmanagedServer> {
    public EarToWasUnmanagedServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected final void generateAdditionStepsForAddedMapping(Ear ear, WasEarMapping mapping, WasUnmanagedServer target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = EarToWasUnmanagedServerMapper.getWebservers(mapping);
        String virtualHostAlias = this.validateAndGetVirtualHostFromMapping(mapping);
        boolean isAppVirtualHostRequired = this.getAppVirtualHostRequired(mapping);
        if (isAppVirtualHostRequired) {
            steps.add(new CreateWasVirtualHostStep(target.getCell(), ear.getName()));
            steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), ear.getName(), virtualHostAlias));
        }
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            steps.add(new CreateWasVirtualHostStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName())));
            steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName()), this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias)));
        }
        steps.add(new StopWasUnmanagedServerStep(target));
        steps.add(new StartWasUnmanagedServerStep(target));
        this.generateDeployStep(ear, mapping, target, webservers, steps);
        List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(mapping);
        for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
            if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
            steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)ear, target, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
        }
        if (isAppVirtualHostRequired) {
            for (WasManagedApacheHttpdServer eachWebServer : webservers) {
                this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, this.validateAndGetVirtualHostFromMapping(mapping));
            }
        }
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getNewRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias));
        }
    }

    @Override
    protected final void generateDeletionStepsForDeletedMapping(Ear ear, WasEarMapping mapping, WasUnmanagedServer target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = EarToWasUnmanagedServerMapper.getWebservers(mapping);
        this.generateStopStep(ear, target, mapping, steps);
        this.generateUndeployStep(ear, target, mapping, steps);
        boolean isAppVirtualHostRequired = this.getAppVirtualHostRequired(mapping);
        if (isAppVirtualHostRequired) {
            steps.add(new DestroyWasVirtualHostStep(target.getCell(), ear.getName()));
        }
        steps.add(new StopWasUnmanagedServerStep(target));
        steps.add(new StartWasUnmanagedServerStep(target));
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            steps.add(new DestroyWasVirtualHostStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName())));
        }
        String virtualHostAlias = this.validateAndGetVirtualHostFromMapping(mapping);
        if (isAppVirtualHostRequired) {
            for (WasManagedApacheHttpdServer eachWebServer : webservers) {
                this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, virtualHostAlias);
            }
        }
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getOldRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias));
        }
    }

    @Override
    protected void generateModificationStepsForModifiedMapping(Ear oldMappingSource, WasEarMapping oldVersionOfModifiedMapping, WasUnmanagedServer oldMappingTarget, Ear newMappingSource, WasEarMapping newVersionOfModifiedMapping, WasUnmanagedServer newMappingTarget, List<Step> steps) {
        boolean mappingSourceChanged = !oldMappingSource.equals((Object)newMappingSource);
        Set<WasManagedApacheHttpdServer> webservers = EarToWasUnmanagedServerMapper.getWebservers(newVersionOfModifiedMapping);
        if (mappingSourceChanged) {
            this.generateStopStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
            this.generateUndeployStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
        }
        if (!oldVersionOfModifiedMapping.getVirtualHost().equals(newVersionOfModifiedMapping.getVirtualHost())) {
            steps.add(new StopWasUnmanagedServerStep(oldMappingTarget));
            steps.add(new DestroyWasVirtualHostStep(oldMappingTarget.getCell(), oldMappingSource.getName()));
            steps.add(new CreateWasVirtualHostStep(newMappingTarget.getCell(), newMappingSource.getName()));
            steps.add(new UpdateWasVirtualHostAliasesStep(newMappingTarget.getCell(), newMappingSource.getName(), this.validateAndGetVirtualHostFromMapping(newVersionOfModifiedMapping)));
            steps.add(new StartWasUnmanagedServerStep(newMappingTarget));
        }
        if (mappingSourceChanged) {
            this.generateDeployStep(newMappingSource, newVersionOfModifiedMapping, newMappingTarget, webservers, steps);
            List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(newVersionOfModifiedMapping);
            for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
                if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
                steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)newMappingSource, newMappingTarget, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
            }
        }
    }

    @Override
    protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasUnmanagedServer server, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(server.getCell(), artifact, Collections.singleton(server), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getClassLoaderPolicy(), mapping.getWarClassLoaderMapping(), mapping.getSecurityRoleUserGroupMappings(), this.getUpdatedWebserversMapping(mapping)));
    }

    @Override
    protected void generateUndeployStep(Ear artifact, WasUnmanagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep(server.getCell(), mapping.getSource()));
    }

    @Override
    protected void generateStartStep(Ear artifact, WasUnmanagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected void generateStopStep(Ear artifact, WasUnmanagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasEarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasEarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasEarMapping mapping) {
        return mapping.getWarsWebserversVHMapping();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasEarMapping mapping) {
        return this.getWebserversAndVirtualHostPerWar(mapping);
    }
}

