/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;

/**
 * Creates a {@link WasManagedApacheHttpdServer} on a {@link WasNodeAgent} that is part of a {@link WasDeploymentManager}
 */
@SuppressWarnings("serial")
public class CreateWasManagedApacheWebServerStep extends WasStepBase {

	private static final String CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-was-managed-apache-web-server.py";

	private WasManagedApacheHttpdServer webserver;

	public CreateWasManagedApacheWebServerStep(WasManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		setDescription("Create WAS managed Apache web server " + webserver + " on node " + webserver.getNode() + " in cell " + webserver.getNode().getCell());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("webserver", webserver);
		context.put("node", webserver.getNode());
		context.put("cell", webserver.getNode().getCell());
		createApacheConfFragmentForWasPlugin(ctx);
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

	private void createApacheConfFragmentForWasPlugin(StepExecutionContext ctx) {
		HostSession rhs = webserver.getHost().getHostSession();
		try {
			HostFile fragmentFile = rhs.getFile(webserver.getApacheConfigFramentFilePath());
			String fragmentContent = webserver.getApacheConfFragmentForWasPluginFileContent();
			ctx.logOutput("Creating apache config fragment file " +  fragmentFile.getPath() + " for was plugin");
			HostFileUtils.putStringToHostFile(fragmentContent, fragmentFile);
		} finally {
			rhs.close();
		}
	}

}
