/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasDeployApplicationStep
extends WasStepBase {
    protected static final String DEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/deploy-application.py";
    protected NamedDeployableArtifact application;
    protected String extension;
    protected WasCell cell;
    protected Collection<WasCluster> clusters;
    protected Collection<WasManagedApacheHttpdServer> webservers;
    protected String virtualHostName;
    protected String contextRoot;

    public WasDeployApplicationStep(WasCell cell, Ear ear, Collection<WasCluster> clusters, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName) {
        super(cell);
        this.init(cell, clusters, webservers, virtualHostName);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)ear);
        this.extension = ".ear";
        this.contextRoot = "";
        this.validate();
        this.initDescription();
    }

    public WasDeployApplicationStep(WasCell cell, War war, Collection<WasCluster> clusters, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName, String contextRoot) {
        super(cell);
        this.init(cell, clusters, webservers, virtualHostName);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)war);
        this.extension = ".war";
        this.contextRoot = (String)Preconditions.checkNotNull((Object)contextRoot);
        this.validate();
        this.initDescription();
    }

    public WasDeployApplicationStep(WasCell cell, EjbJar ejbJar, Collection<WasCluster> clusters, Collection<WasManagedApacheHttpdServer> webservers) {
        super(cell);
        this.init(cell, clusters, webservers, null);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)ejbJar);
        this.extension = ".jar";
        this.contextRoot = "";
        this.validate();
        this.initDescription();
    }

    private void init(WasCell cell, Collection<WasCluster> clusters, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName) {
        this.cell = (WasCell)((Object)Preconditions.checkNotNull((Object)((Object)cell)));
        this.clusters = (Collection)Preconditions.checkNotNull(clusters);
        this.webservers = new HashSet<WasManagedApacheHttpdServer>(webservers);
        this.virtualHostName = StringUtils.defaultString((String)virtualHostName, (String)"default_host");
    }

    private void validate() {
        if (this.clusters.isEmpty()) {
            throw new IllegalArgumentException("Collection of clusters is empty");
        }
        for (WasCluster eachCluster : this.clusters) {
            if (eachCluster.getCell().equals((Object)this.cell)) continue;
            throw new IllegalArgumentException("Cluster " + eachCluster.getLabel() + " is part of cell " + (Object)((Object)eachCluster.getCell()) + " so it cannot be targeted when deploying to cell " + this.cell.getLabel());
        }
        for (WasManagedApacheHttpdServer eachWebServer : this.webservers) {
            if (eachWebServer.getNode().getCell().equals((Object)this.cell)) continue;
            throw new IllegalArgumentException("WebServer " + eachWebServer.getLabel() + " is part of cell " + (Object)((Object)eachWebServer.getNode().getCell()) + " so it cannot be targeted when deploying to cell " + this.cell.getLabel());
        }
    }

    private void initDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("Deploy application ");
        desc.append(ExtendedStringUtils.getQuotedString((String)this.application.getLabel()));
        if (this.clusters.size() == 1) {
            desc.append(" on cluster ");
            desc.append(ExtendedStringUtils.getQuotedString((String)this.clusters.iterator().next().getLabel()));
        } else {
            desc.append(" on multiple clusters ");
        }
        if (this.webservers.size() == 1) {
            desc.append(" and webserver " + ExtendedStringUtils.getQuotedString((String)this.webservers.iterator().next().getLabel()));
        } else if (this.webservers.size() > 1) {
            desc.append(" and multiple webservers ");
        }
        desc.append(" in cell ");
        desc.append(ExtendedStringUtils.getQuotedString((String)this.cell.getLabel()));
        desc.append(" with virtual host ");
        desc.append(this.virtualHostName);
        this.setDescription(desc.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.cell.connectToAdminHost();
        try {
            HostFile uploadedApplicationFile = this.uploadApplication(rhs);
            String earFilePath = uploadedApplicationFile.getPath().replace('\\', '/');
            StringBuilder targets = new StringBuilder();
            for (WasCluster eachCluster : this.clusters) {
                if (targets.length() > 0) {
                    targets.append("+");
                }
                targets.append("WebSphere:cell=");
                targets.append(this.cell.getName());
                targets.append(",cluster=");
                targets.append(eachCluster.getName());
            }
            for (WasManagedApacheHttpdServer eachWebserver : this.webservers) {
                targets.append("+WebSphere:cell=");
                targets.append(this.cell.getName());
                targets.append(",node=");
                targets.append(eachWebserver.getNode().getName());
                targets.append(",server=");
                targets.append(eachWebserver.getName());
            }
            int res = this.executeWsadminJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH, this.application.getName(), earFilePath, targets.toString(), this.virtualHostName, this.contextRoot);
            boolean bl = res == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostFile uploadedApplicationFile;
        HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
        HostFile applicationFileToUpload = lhs.getFile(this.application.getLocation());
        try {
            uploadedApplicationFile = rhs.getTempFile(this.application.getName(), this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile);
        }
        finally {
            lhs.close();
        }
        return uploadedApplicationFile;
    }

    public NamedDeployableArtifact getApplication() {
        return this.application;
    }

    public String getExtension() {
        return this.extension;
    }

    public WasCell getCell() {
        return this.cell;
    }

    public Collection<WasCluster> getClusters() {
        return this.clusters;
    }

    public Collection<WasManagedApacheHttpdServer> getWebservers() {
        return this.webservers;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }
}

