package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Undeploys a {@link NamedDeployableArtifact} from a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class WasUndeployApplicationStep extends WasStepBase {

	protected static final String UNDEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "undeploy-application.py";

	private NamedDeployableArtifact application;

	public WasUndeployApplicationStep(WasCell cell, Ear ear) {
		super(cell);
		this.application = ear;
		init();
	}

	public WasUndeployApplicationStep(WasCell cell, War war) {
		super(cell);
		this.application = war;
		init();
	}

	public WasUndeployApplicationStep(WasCell cell, EjbJar ejbJar) {
		super(cell);
		this.application = ejbJar;
		init();
	}

	private void init() {
		setDescription("Undeploy application " + ExtendedStringUtils.getQuotedString(application.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		int res = executeWsadminJythonScriptResource(ctx, UNDEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH, application.getName());
		return res == 0;
	}

	public NamedDeployableArtifact getApplication() {
		return application;
	}

}
