package com.xebialabs.deployit.plugin.was.step;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Updates the <a href="http://publib.boulder.ibm.com/infocenter/wasinfo/v6r1//index.jsp?topic=/com.ibm.websphere.base.doc/info/aes/ae/tcws_plugin_vhost.html">
 * Virtual Host</a> by adding an alias in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class UpdateWasVirtualHostAliasesStep extends WasStepBase {

	protected static final String UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "update-vhost-aliases.py";

	protected String vhostName;

	protected String aliasHostName;

	protected String aliasPortNumber;

	public UpdateWasVirtualHostAliasesStep(WasCell cell, String vhostName, String alias) {
		super(cell);
		this.vhostName = vhostName;
		String[] aliasComponents = StringUtils.split(alias, ':');
		if (aliasComponents == null || aliasComponents.length != 2) {
			throw new ResolutionException("Virtual host definition \"" + alias + "\" is not a valid host specification");
		}
		this.aliasHostName = aliasComponents[0];
		this.aliasPortNumber = aliasComponents[1];
		setDescription("Add alias " + aliasHostName + ":" + aliasPortNumber + " to WAS virtual host " + vhostName + " in cell "
				+ ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH, vhostName, aliasPortNumber, aliasHostName) == 0);
	}

	public String getVhostName() {
		return vhostName;
	}

	public String getAliasHostName() {
		return aliasHostName;
	}

	public String getAliasPortNumber() {
		return aliasPortNumber;
	}

}
