package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Synchronizes the a {@link WasNode} with its {@link WasCell}
 */
@SuppressWarnings("serial")
public class SynchronizeWasNodeStep extends WasStepBase {

	protected static final String SYNCHRONIZE_NODE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "synchronize-node.py";

	protected WasNode node;

	public SynchronizeWasNodeStep(WasNode node) {
		super(node.getCell());
		this.node = node;
		setDescription("Synchronize node " + ExtendedStringUtils.getQuotedString(node.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, SYNCHRONIZE_NODE_SCRIPT_RESOURCE_PATH, cell.getName(), node.getName()) == 0);
	}

}
