package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Starts the members of a {@link WasCluster} on a {@link WasNode}
 */
@SuppressWarnings("serial")
public class StartWasClusterMembersStep extends WasStepBase {

	protected static final String START_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "start-cluster-members.py";

	protected WasCluster cluster;

	protected WasNode node;

	public StartWasClusterMembersStep(WasCluster cluster, WasNode node) {
		this(cluster.getCell().getHost(), cluster.getCell(), cluster, node);
	}

	public StartWasClusterMembersStep(Host cellHost, WasCell cell, WasCluster cluster, WasNode node) {
		super(cell);
		this.cluster = cluster;
		this.node = node;
		setDescription("Start members of cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel()) + " on node " + ExtendedStringUtils.getQuotedString(node.getLabel())
				+ " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		String numberOfClusterMembers = Integer.toString(cluster.getNumberOfClusterMembers());

		return (executeWsadminJythonScriptResource(ctx, START_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, node.getName(), clusterMemberNamesPrefix, numberOfClusterMembers) == 0);
	}

}
