package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;

/**
 * Destroys a {@link WasCluster} and all its members in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class DestroyWasClusterStep extends WasStepBase {

	protected static final String DESTROY_CLUSTER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-webspherecluster.py";

	protected WasCluster cluster;

	public DestroyWasClusterStep(WasCluster cluster) {
		this(cluster.getCell().getHost(), cluster.getCell(), cluster);
	}

	public DestroyWasClusterStep(Host cellHost, WasCell cell, WasCluster cluster) {
		super(cell);
		this.cluster = cluster;
		setDescription("Destroy cluster " + cluster.getLabel() + " in cell " + cell.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, DESTROY_CLUSTER_SCRIPT_RESOURCE_PATH, cluster.getName()) == 0);
	}

}
