package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopic;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasWmqTopic} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasWmqTopicStep extends WasStepBase {
	
	public static String CREATE_WMQ_T_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-wmq-topic.py";

	private WasCluster cluster;
	private WasWmqTopic t;

	public CreateWasWmqTopicStep(WasCluster existingCluster, WasWmqTopic t) {
		super(existingCluster.getCell());
		this.cluster = existingCluster;
		this.t = t;
		setDescription("Create WebSphere MQ Topic " + ExtendedStringUtils.getQuotedString(t.getLabel()) + " in cluster " + existingCluster.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("t", t);
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_T_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
