package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueue;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasWmqQueue} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasWmqQueueStep extends WasStepBase implements Step {

	public static String CREATE_WMQ_QUEUE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-wmq-queue.py";

	private WasCluster cluster;

	private WasWmqQueue q;

	public CreateWasWmqQueueStep(WasCluster cluster, WasWmqQueue q) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.q = q;
		setDescription("Create WebSphere MQ Queue " + ExtendedStringUtils.getQuotedString(q.getLabel()) + " in cluster " + cluster.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("q", q);
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_QUEUE_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
