package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
/**
 * Creates a {@link WasManagedApacheHttpdServer} on a {@link WasNode} that is part of a {@link WasCell}
 */
@SuppressWarnings("serial")
public class CreateWasManagedApacheWebServerStep extends WasStepBase {

	private static final String CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-was-managed-apache-web-server.py";

	private WasManagedApacheHttpdServer webserver;

	public CreateWasManagedApacheWebServerStep(WasManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		setDescription("Create WAS managed Apache web server" + webserver + " on node " + webserver.getNode() + " in cell " + webserver.getNode().getCell());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("webserver", webserver);
		context.put("node", webserver.getNode());
		context.put("cell", webserver.getNode().getCell());
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
