package com.xebialabs.deployit.plugin.was.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.util.ExtendedStringUtils;

@SuppressWarnings("serial")
public abstract class ControlApplicationStep extends WasStepBase {

	protected static final String CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "control-application.py";

	protected WasCluster cluster;

	protected NamedDeployableArtifact application;

	protected String command;

	protected List<String> applicationManagerObjectNames;

	protected ControlApplicationStep(WasCluster cluster, NamedDeployableArtifact application, String command) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.application = application;
		this.command = command;

		Map<WasNode, List<String>> serverNamesPerNode = cluster.getServerNamesPerNode();
		applicationManagerObjectNames = new ArrayList<String>();
		for (Map.Entry<WasNode, List<String>> each : serverNamesPerNode.entrySet()) {
			WasNode eachNode = each.getKey();
			List<String> eachNodeServerNames = each.getValue();
			for (String eachServerName : eachNodeServerNames) {
				applicationManagerObjectNames.add("cell=" + cell.getName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process="
						+ eachServerName + ",*");
			}
		}

		setDescription(command + " " + ExtendedStringUtils.getQuotedString(application.getLabel()) + " on cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel())
				+ " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		String[] args = new String[2 + applicationManagerObjectNames.size()];
		args[0] = application.getName();
		args[1] = command;
		for (int i = 0; i < applicationManagerObjectNames.size(); i++) {
			args[i + 2] = applicationManagerObjectNames.get(i);
		}
		return executeWsadminJythonScriptResource(ctx, CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH, args) == 0;
	}

}
