package com.xebialabs.deployit.plugin.was.runbook;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.CreateWasManagedApacheWebServerStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasManagedApacheWebServerStep;

/**
 * Supports the creation, modification and deletion of a 
 * {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer}.
 * 
 * <h4>Conditions</h4>
 * 
 * Will trigger if the change plan contains the addition, modification or
 * deletion of a {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer}.
 * 
 * <h4>Actions</h4>
 * 
 * Addition:
 * 
 * <ol>
 * <li>Create {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer} in a {@link WasCell cell}
 * </ol>
 * 
 * All Modifications are handled as Deletion and Addition.
 * <p>
 * Deletion:
 * 
 * <ol>
 * <li>Delete {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer} from a {@link WasCell cell}
 * </ol>
 */
public class WasManagedApacheWebServerRunBook extends WasRunBookBase<WasManagedApacheHttpdServer> implements RunBook {

	public WasManagedApacheWebServerRunBook() {
		super(WasManagedApacheHttpdServer.class);
	}

	@Override
	protected void resolve(Change<WasManagedApacheHttpdServer> change, ChangePlan changePlan, List<Step> steps) {
		if (change.isDeletion() || change.isModification()) {
			destroyWasManagedApacheWebServer(change, steps);
		}

		if (change.isAddition()|| change.isModification()) {
			createWasManagedApacheWebServer(change, steps);
		}
	}

	private void createWasManagedApacheWebServer(Change<WasManagedApacheHttpdServer> change, List<Step> steps) {
		steps.add(new CreateWasManagedApacheWebServerStep(change.getNewRevision()));
	}

	private void destroyWasManagedApacheWebServer(Change<WasManagedApacheHttpdServer> change, List<Step> steps) {
		steps.add(new DestroyWasManagedApacheWebServerStep(change.getOldRevision()));
	}

}
