package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqQueueConnectionFactoryStep;

public class WasWmqQueueConnectionFactoryToWasClusterMapper extends MappingAgnosticStepGeneratingMapper<WasWmqQueueConnectionFactory, WasCluster> {

	public WasWmqQueueConnectionFactoryToWasClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasWmqQueueConnectionFactory resource, WasCluster cluster, List<Step> steps) {
		steps.add(new CreateWasWmqQueueConnectionFactoryStep(cluster, resource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasWmqQueueConnectionFactory resource, WasCluster cluster, List<Step> steps) {
		steps.add(new DestroyWasWmqQueueConnectionFactoryStep(cluster, resource));
	}

}
