package com.xebialabs.deployit.plugin.was.ci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;

@SuppressWarnings("serial")
@ConfigurationItem
public class WasEarMapping extends EarMapping {

	@ConfigurationItemProperty(description = "Set of webservers that expose the Eneterprise Application")
	private Set<WasManagedApacheHttpdServer> webservers;

	public WasEarMapping() {
		// default constructor
	}

	@SuppressWarnings("unchecked")
	public WasEarMapping(Ear source, Serializable target, String virtualHost) {
		this(source, target, (Set<WasManagedApacheHttpdServer>) Collections.EMPTY_SET, virtualHost);
	}

	public WasEarMapping(Ear source, Serializable target, Set<WasManagedApacheHttpdServer> webservers, String virtualHost) {
		super(source, target, virtualHost);
		this.webservers = webservers;
	}

	public Set<WasManagedApacheHttpdServer> getWebservers() {
		return webservers;
	}

	public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
		this.webservers = webservers;
	}

}
