#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys

cellname = sys.argv.pop(0)

cellid = AdminConfig.getid('/Cell:' + cellname)
if cellid == '':
	print 'Deployit INFO: Cell with name ' + cellname + ' does not exist'
	sys.exit(-1)

while len(sys.argv) >= 2:
	nameInNameSpace = sys.argv.pop(0)
	name = nameInNameSpace.replace('/', '_')
	stringToBind = sys.argv.pop(0)
	bindingidsInOneString = AdminConfig.getid('/Cell:' + cellname + '/StringNameSpaceBinding:' + name)
	bindingids = bindingidsInOneString.split()
	for each in bindingids:
		AdminConfig.remove(each)
		print 'Deployit INFO: Removed existing name space binding ' + name + ' at ' + nameInNameSpace + ' from cell ' + cellname
	
	AdminConfig.create('StringNameSpaceBinding', cellid, [['name', name], ['nameInNameSpace', nameInNameSpace], ['stringToBind', stringToBind]])
	print 'Deployit INFO: Created name space binding ' + name + ' at ' + nameInNameSpace + ' in cell ' + cellname

AdminConfig.save()
print 'Deployit INFO: Saved configuration'
