/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class CreateWasWmqQueueConnectionFactoryStep
extends WasStepBase
implements Step {
    public static String CREATE_WMQ_QCF_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-wmq-queue-connection-factory.py";
    private WasCluster cluster;
    private WasServer server;
    private WasWmqQueueConnectionFactory qcf;

    public CreateWasWmqQueueConnectionFactoryStep(WasCluster cluster, WasWmqQueueConnectionFactory qcf) {
        super(cluster.getCell());
        this.cluster = cluster;
        this.server = null;
        this.qcf = qcf;
        this.setDescription("Create WebSphere MQ Queue Connection Factory " + ExtendedStringUtils.getQuotedString((String)qcf.getLabel()) + " in cluster " + cluster.getLabel());
    }

    public CreateWasWmqQueueConnectionFactoryStep(WasServer server, WasWmqQueueConnectionFactory qcf) {
        super(server.getNode().getCell());
        this.cluster = null;
        this.server = server;
        this.qcf = qcf;
        this.setDescription("Create WebSphere MQ Queue Connection Factory " + ExtendedStringUtils.getQuotedString((String)qcf.getLabel()) + " in server " + server.getLabel());
    }

    public boolean execute(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        if (this.cluster != null) {
            context.put("cluster", (Serializable)((Object)this.cluster));
        }
        if (this.server != null) {
            context.put("server", (Serializable)((Object)this.server));
            context.put("node", (Serializable)((Object)this.server.getNode()));
            context.put("cell", (Serializable)((Object)this.server.getNode().getCell()));
        }
        context.put("qcf", this.qcf);
        context.put("qcfQueueManagerHost", (Serializable)this.qcf.getQueueManagerHost());
        int res = this.executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_QCF_SCRIPT_RESOURCE_PATH, new String[0]);
        return res == 0;
    }
}

