/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class CreateWasClusterMembersStep
extends WasStepBase {
    protected static final String CREATE_CLUSTER_MEMBERS_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-cluster-members.py";
    protected WasCluster cluster;
    protected WasNode node;

    public CreateWasClusterMembersStep(WasCluster cluster, WasNode node) {
        this(cluster.getCell().getHost(), cluster.getCell(), cluster, node);
    }

    public CreateWasClusterMembersStep(Host cellHost, WasCell cell, WasCluster cluster, WasNode node) {
        super(cell);
        this.cluster = cluster;
        this.node = node;
        this.setDescription("Create members for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \"" + cell.getLabel() + "\"");
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = this.cluster.getMemberNamePrefix(this.node.getName());
        String numberOfClusterMembers = Integer.toString(this.cluster.getNumberOfClusterMembers());
        String startOfBootstrapPortNumberRange = Integer.toString(this.cluster.getStartOfBootstrapPortNumberRange());
        String startOfSoapConnectorPortNumberRange = Integer.toString(this.cluster.getStartOfSoapConnectorPortNumberRange());
        return this.executeWsadminJythonScriptResource(ctx, CREATE_CLUSTER_MEMBERS_SCRIPT_RESOURCE_PATH, this.node.getName(), this.cluster.getName(), clusterMemberNamesPrefix, numberOfClusterMembers, startOfBootstrapPortNumberRange, "BOOTSTRAP_ADDRESS", startOfSoapConnectorPortNumberRange, "SOAP_CONNECTOR_ADDRESS") == 0;
    }
}

