/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Checks if an {@link NamedDeployableArtifact application} is ready to be started on a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class WasIsAppReadyStep extends WasStepBase {

	protected static final String IS_APP_READY_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "is-app-ready.py";

	protected WasCluster cluster;

	protected NamedDeployableArtifact application;

	protected WasIsAppReadyStep(WasCluster cluster, NamedDeployableArtifact application) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.application = application;

		setDescription("Is application " + ExtendedStringUtils.getQuotedString(application.getLabel()) + " on cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel())
				+ " ready?");
	}

	public boolean execute(StepExecutionContext ctx) {
		String[] args = new String[1];
		args[0] = application.getName();
		return executeWsadminJythonScriptResource(ctx, IS_APP_READY_SCRIPT_RESOURCE_PATH, args) == 0;
	}
}
