/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasDataSource} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasDataSourceStep extends WasStepBase {

	public static final String CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";
	public static final String CREATE_DATASOURCE_ON_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource-on-server.py";

	private WasDataSource wasDataSource;

	private WasCluster cluster;
	private WasServer server;

	public CreateWasDataSourceStep(WasDataSource wasDataSource, WasCluster cluster) {
		super(cluster.getCell());
		this.wasDataSource = wasDataSource;
		this.cluster = cluster;
		this.server = null;
		setDescription("Create datasource " + ExtendedStringUtils.getQuotedString(wasDataSource.getLabel()) + " in cell "
				+ ExtendedStringUtils.getQuotedString(cluster.getCell().getLabel()) + " for cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel()));
	}
	
	public CreateWasDataSourceStep(WasDataSource wasDataSource, WasServer server) {
		super(server.getNode().getCell());
		this.wasDataSource = wasDataSource;
		this.cluster = null;
		this.server = server;
		setDescription("Create datasource " + ExtendedStringUtils.getQuotedString(wasDataSource.getLabel()) + " in node "
				+ ExtendedStringUtils.getQuotedString(server.getNode().getLabel()) + " for server " + ExtendedStringUtils.getQuotedString(server.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		if (cluster != null && server == null) {
			return executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH, wasDataSource.getName(), wasDataSource.getDescription(), wasDataSource.getJndiName(),
					wasDataSource.getProvider(), wasDataSource.getDataStoreHelperClass(), wasDataSource.getUrl(), wasDataSource.getUsername(), wasDataSource
							.getPassword(), Integer.toString(wasDataSource.getStatementCacheSize()), cell.getName(), cluster.getName()) == 0;
		} else if (cluster == null && server != null) {
			return executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_ON_SERVER_SCRIPT_RESOURCE_PATH, wasDataSource.getName(), wasDataSource.getDescription(), wasDataSource.getJndiName(),
					wasDataSource.getProvider(), wasDataSource.getDataStoreHelperClass(), wasDataSource.getUrl(), wasDataSource.getUsername(), wasDataSource
							.getPassword(), Integer.toString(wasDataSource.getStatementCacheSize()), cell.getName(), server.getNode().getName(), server.getName()) == 0;
		}
		return false;
	}

	public WasDataSource getWasDataSource() {
		return wasDataSource;
	}

	public WasCluster getCluster() {
		return cluster;
	}
	
	public WasServer getServer() {
		return server;
	}

}
