/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;

public class StartWasClusterMembersStep
extends WasStepBase {
    protected static final String START_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/start-cluster-members.py";
    protected WasCluster cluster;
    protected WasNode node;

    public StartWasClusterMembersStep(WasCluster cluster, WasNode node) {
        this(cluster.getCell().getHost(), cluster.getCell(), cluster, node);
    }

    public StartWasClusterMembersStep(Host cellHost, WasCell cell, WasCluster cluster, WasNode node) {
        super(cell);
        this.cluster = cluster;
        this.node = node;
        this.setDescription("Start members of cluster " + ExtendedStringUtils.getQuotedString((String)cluster.getLabel()) + " on node " + ExtendedStringUtils.getQuotedString((String)node.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)cell.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(this.cluster.getName(), this.node.getName());
        String numberOfClusterMembers = Integer.toString(this.cluster.getNumberOfClusterMembers());
        return this.executeWsadminJythonScriptResource(ctx, START_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, this.node.getName(), clusterMemberNamesPrefix, numberOfClusterMembers) == 0;
    }
}

