/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Synchronizes the a {@link WasNode} with its {@link WasCell}
 */
@SuppressWarnings("serial")
public class SynchronizeWasNodeStep extends WasStepBase {

	protected static final String SYNCHRONIZE_NODE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "synchronize-node.py";

	protected WasNode node;

	public SynchronizeWasNodeStep(WasNode node) {
		super(node.getCell());
		this.node = node;
		setDescription("Synchronize node " + ExtendedStringUtils.getQuotedString(node.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, SYNCHRONIZE_NODE_SCRIPT_RESOURCE_PATH, cell.getName(), node.getName()) == 0);
	}

}
