/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class CapturingExecutionContext<C extends ExecutionContext>
implements ExecutionContext {
    protected C originalContext;
    protected List<String> capturedOutput = Lists.newArrayList();
    protected List<String> capturedError = Lists.newArrayList();

    public CapturingExecutionContext(C c) {
        this.originalContext = c;
    }

    public void logOutput(String string) {
        this.originalContext.logOutput(string);
        this.capturedOutput.add(string);
    }

    public void logError(String string) {
        this.originalContext.logError(string);
        this.capturedError.add(string);
    }

    public void logError(String string, Throwable throwable) {
        this.originalContext.logError(string, throwable);
        this.capturedError.add(string);
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.capturedError.add(stringWriter.toString());
        }
    }

    public Object getAttribute(String string) {
        return this.originalContext.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.originalContext.setAttribute(string, object);
    }

    public List<String> getCapturedOutput() {
        return this.capturedOutput;
    }

    public List<String> getCapturedError() {
        return this.capturedError;
    }
}

