/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.DeploymentPlannerFactory;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.test.deployment.SimpleReplacer;
import com.xebialabs.deployit.test.support.LoggingDeploymentExecutionContext;
import com.xebialabs.deployit.test.support.LoggingExecutionContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeployitTester {
    private final DeploymentPlanner planner;
    private final Inspector inspector;

    public static DeployitTester build() {
        DeploymentPlannerFactory plannerFactory = new DeploymentPlannerFactory();
        return new DeployitTester(plannerFactory.planner(), new Inspector());
    }

    private DeployitTester(DeploymentPlanner planner, Inspector inspector) {
        this.planner = planner;
        this.inspector = inspector;
    }

    public Plan resolvePlan(DeltaSpecification spec) {
        return this.planner.plan(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> inspect(ConfigurationItem item) {
        LoggingExecutionContext ctx = new LoggingExecutionContext(DeployitTester.class);
        try {
            List<ConfigurationItem> list = this.inspect(item, ctx);
            return list;
        }
        finally {
            ctx.destroy();
        }
    }

    public List<ConfigurationItem> inspect(ConfigurationItem item, ExecutionContext ctx) {
        return this.inspector.inspect(item, ctx);
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType) {
        return this.generateDeployed(d, c, deployedType, null);
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType, Map<String, String> placeholders) {
        Descriptor deployed = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed configurationItem = (Deployed)deployed.newInstance();
        configurationItem.setDeployable(d);
        configurationItem.setContainer(c);
        configurationItem.setId(c.getId() + "/" + this.substringAfterLastSlash(d.getId()));
        Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)d.getType());
        for (PropertyDescriptor propertyDescriptor : deployed.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            PropertyDescriptor deployablePropertyDescriptor = deployableDescriptor.getPropertyDescriptor(name);
            if (deployablePropertyDescriptor == null) continue;
            if (propertyDescriptor.getName().equals("placeholders")) {
                propertyDescriptor.set((ConfigurationItem)configurationItem, (Object)Maps.newHashMap());
                continue;
            }
            propertyDescriptor.set((ConfigurationItem)configurationItem, deployablePropertyDescriptor.get((ConfigurationItem)d));
        }
        if (configurationItem instanceof DerivedArtifact) {
            DerivedArtifact da = (DerivedArtifact)configurationItem;
            if (placeholders != null) {
                da.setPlaceholders(placeholders);
            }
            da.initFile((PlaceholderReplacer)new SimpleReplacer());
        }
        return configurationItem;
    }

    private String substringAfterLastSlash(String id) {
        int i = id.lastIndexOf(47);
        if (i > -1) {
            return id.substring(i + 1);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result executePlan(Plan plan) {
        LoggingDeploymentExecutionContext ctx = new LoggingDeploymentExecutionContext(this.getClass());
        try {
            Step.Result result = this.executePlan(plan, ctx);
            return result;
        }
        finally {
            ctx.destroy();
        }
    }

    public Step.Result executePlan(Plan plan, DeploymentExecutionContext context) {
        Step.Result result = Step.Result.Warn;
        List steps = plan.getSteps();
        try {
            DeploymentStep step;
            Iterator i$ = steps.iterator();
            while (i$.hasNext() && (result = (step = (DeploymentStep)i$.next()).execute((ExecutionContext)context)) != Step.Result.Fail) {
            }
            return result;
        }
        catch (Exception e) {
            throw new DeployitTesterException(e);
        }
    }

    public static class DeployitTesterException
    extends RuntimeException {
        DeployitTesterException(String message, Object ... params) {
            super(String.format(message, params));
        }

        DeployitTesterException(Exception e) {
            super(e);
        }
    }
}

