package com.xebialabs.deployit.test.support;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class LoggingInspectionExecutionContext extends LoggingExecutionContext implements InspectionExecutionContext {

	private List<ConfigurationItem> discoveredItems = newArrayList();

	public LoggingInspectionExecutionContext(Class<?> clazz) {
	    super(clazz);
    }

	@Override
	public void discovered(ConfigurationItem item) {
		discoveredItems.add(item);
	}

	public List<? extends ConfigurationItem> getDiscoveredItems() {
		return discoveredItems;
	}

}
