/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.lookup;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * CI that can be used to lookup external values.
 */
@PublicApiRef
public interface LookupValueProvider extends ConfigurationItem {

    /**
     * Check Lookup Value Provider health
     * @return Health flag
     */
    default boolean isHealthy() {
        return true;
    }

    /**
     * Lookup an external value by key.
     * @param key The key to find
     * @param password Whether it is used for a password property.
     * @return The value found
     * @throws Exception when the lookup cannot be performed or the provider cannot provide a value, e.g. when a secret is requested for a non password field.
     */
    String lookup(String key, boolean password) throws Exception;
}
