/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="range")
public @interface Range {
    public static final String DEFAULT_MESSAGE = "Value %s is not in range [%s, %s]";
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;

    public int minimum() default -2147483648;

    public int maximum() default 0x7FFFFFFF;

    public String message() default "Value %s is not in range [%s, %s]";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Integer> {
        private int minimum = Integer.MIN_VALUE;
        private int maximum = Integer.MAX_VALUE;
        private String message = "Value %s is not in range [%s, %s]";

        @Override
        public void validate(Integer value, ValidationContext context) {
            if (value < this.minimum || value > this.maximum) {
                context.error(this.message, value, this.minimum, this.maximum);
            }
        }
    }
}

