package com.xebialabs.deployit.plugin.api.udm.base;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Placeholders
@Metadata(virtual = true, description = "The supertype of all DeployedArtifacts.")
public class BaseDeployedArtifact<D extends DeployableArtifact, C extends Container> extends BaseDeployed<D, C> implements DerivedArtifact<D> {

    private OverthereFile file;

    @Property(category = "Placeholders", description = "A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required = false)
    private Map<String, String> placeholders = newHashMap();

    public OverthereFile getFile() {
        return file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public D getSourceArtifact() {
        return getDeployable();
    }
}
