package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

/**
 * Represents a {@link Deployable} deployed to a {@link Container}.
 */
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all Deployeds.")
public class BaseDeployed<D extends Deployable, C extends Container> extends BaseConfigurationItem implements Deployed<D, C> {

    @Property(required = false, description = "The deployable that this deployed is derived from.")
    private D deployable;

    @Property(asContainment = true, description = "The container on which this deployed runs.")
    private C container;

    /**
     * Default constructor should be public in order to be able to instantiate this.
     */
    public BaseDeployed() {
    }

    protected BaseDeployed(D deployable, C container) {
        this.deployable = deployable;
        this.container = container;
    }

    @Override
    public D getDeployable() {
        return deployable;
    }

    @Override
    public void setDeployable(D deployable) {
        this.deployable = deployable;
    }

    @Override
    public C getContainer() {
        return container;
    }

    @Override
    public void setContainer(C container) {
        this.container = container;
    }

}
