package com.xebialabs.deployit.plugin.api.udm.base;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Sets.newTreeSet;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all DeployableArtifacts.")
public class BaseDeployableArtifact extends BaseDeployable implements DeployableArtifact {

    private OverthereFile file;

    @Property(category = "Placeholders", description = "Whether to scan this artifact for placeholders when it is imported", required = false, defaultValue = "true")
    private boolean scanPlaceholders;

    @Property(category = "Placeholders", description = "Placeholders detected in this artifact", required = false)
    private Set<String> placeholders = newTreeSet();

    @Property(category = "Placeholders", description = "Regular expression that matches file names of text files", hidden = true, defaultValue =
                                        ".+\\.(" +
                                        "cfg | conf | config | ini | properties | props | txt | " +
                                        "asp | aspx | htm | html | jsf | jsp | xht | xhtml | " +
                                        "sql | " +
                                        "xml | xsd | xsl | xslt" +
                                        ")")
    private String textFileNamesRegex;

    @Property(category = "Placeholders", description = "Regular expression that matches file names that must be excluded from scanning", required = false)
    private String excludeFileNamesRegex;

    public OverthereFile getFile() {
        return file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public boolean isScanPlaceholders() {
        return scanPlaceholders;
    }

    public void setScanPlaceholders(boolean scanPlaceholders) {
        this.scanPlaceholders = scanPlaceholders;
    }

    public Set<String> getPlaceholders() {
        return placeholders;
    }

    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }
    
    public String getTextFileNamesRegex() {
        return textFileNamesRegex;
    }

    public void setTextFileNamesRegex(String textFileNamesRegex) {
        this.textFileNamesRegex = textFileNamesRegex;
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return excludeFileNamesRegex;
    }

    public void setExcludeFileNamesRegex(String excludeFileNamesRegex) {
        this.excludeFileNamesRegex = excludeFileNamesRegex;
    }

}
