package com.xebialabs.deployit.plugin.api.udm;


import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.ENVIRONMENTS;

/**
 * Represents a collection of middleware CI's that belong together.
 */
@SuppressWarnings("serial")
@Metadata(description = "A group where middleware CI's can be added, can serve as a target for a deployment.", root = ENVIRONMENTS)
public class Environment extends BaseConfigurationItem {

    /*
     * Members are not contained in environments.
     */
	@Property(required = false)
	private Set<Container> members = newHashSet();

	/*
	 * Zero or more dictionaries associated with an environment.
	 */
	@Property(required = false)
	private List<Dictionary> dictionaries = newArrayList();

	public Environment() {
		//
	}
	
	public Environment(Container... members) {
		HashSet<Container> memberSet = newHashSet();
		for(Container each : members) {
			memberSet.add(each);
		}
		setMembers(memberSet);
	}

	public Set<Container> getMembers() {
		return members;
	}

	@SuppressWarnings("unchecked")
	public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
		Set<T> matchingMembers = new HashSet<T>();
		for (Container member : getMembers()) {
			if (classType.isInstance(member)) {
				matchingMembers.add((T) member);
			}
		}
		return matchingMembers;
	}

	public void setMembers(Set<Container> members) {
		this.members = members;
	}

	public void addMember(Container member) {
		members.add(checkNotNull(member));
	}

	public List<Dictionary> getDictionaries() {
		return dictionaries;
	}

	public void setDictionaries(List<Dictionary> dictionaries) {
		this.dictionaries = dictionaries;
	}
}
