package com.xebialabs.deployit.plugin.api.reflect;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.google.common.base.Predicate;

class SyntheticHelper {

    static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = getOptionalTypeAttribute(element,attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf(typeAttr);
        }
        return type;
    }
    static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return getOptionalTypeAttribute(element, attributeName, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return Boolean.valueOf(getOptionalStringAttribute(element, attributeName, Boolean.toString(defaultValue)));
    }
    static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

	static Iterator<Element> childByName(final Element element, final Predicate<String> matcher) {
		return new Iterator<Element>() {
			private int i = 0;
			private NodeList childNodes = element.getChildNodes();
			private int nextIndex = 0;

			@Override
			public boolean hasNext() {
				if (nextIndex == i) nextIndex = findNext();
				return nextIndex > i;
			}

			@Override
			public Element next() {
				if (nextIndex == i) nextIndex = findNext();
				if (nextIndex < i) throw new NoSuchElementException("There are no more matching elements");
				i = nextIndex;

				return (Element) childNodes.item(i);
			}

			private int findNext() {
				int next = i;
				while (next < childNodes.getLength()) {
					next++;
					if (childNodes.item(next) instanceof Element) {
						Element e = (Element) childNodes.item(next);
						if (matcher.apply(e.getNodeName())) {
							return next;
						}
					}
				}
				return i - 1;
			}

			@Override
			public void remove() {
				throw new UnsupportedOperationException();
			}
		};
	}

	static <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
		while (iterator.hasNext()) {
			closure.call(iterator.next());
		}
	}

    public static interface Closure<E> {
        void call(E e);
    }
}
