/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="regex")
@Target(value={ElementType.FIELD})
public @interface Regex {
    public static final String DEFAULT_MESSAGE = "Value '%s' did not conform to pattern %s";

    public String pattern();

    public String message() default "Value '%s' did not conform to pattern %s";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String pattern;
        private String message = "Value '%s' did not conform to pattern %s";

        @Override
        public void validate(String value, ValidationContext context) {
            if (value != null && !Pattern.compile(this.pattern).matcher(value).matches()) {
                context.error(this.message, value, this.pattern);
            }
        }
    }
}

