package com.xebialabs.deployit.plugin.api.udm.artifact;

import java.util.Map;

public interface DerivedArtifact<D extends SourceArtifact> extends Artifact {

	D getSourceArtifact();

	Map<String, String> getPlaceholders();

	void setPlaceholders(Map<String, String> placeholders);

	/**
	 * Only called in case the DeployedArtifact has a corresponding set Deployable Artifact.
	 *
	 * @param replacer The replacer that can be used to replace placeholders for this DeployedArtifact.
	 */
	void initFile(PlaceholderReplacer replacer);

}
